local t = Def.ActorFrame {};

t[#t+1] = Def.ActorFrame {
	Def.Sprite {
		Texture=THEME:GetPathG("ScreenBackground", "metal");
		InitCommand=function(self)
			self:zoomto(SCREEN_WIDTH,SCREEN_HEIGHT):customtexturerect(0,0,SCREEN_WIDTH*4/2048,SCREEN_HEIGHT*4/2048)
		end;
		OnCommand=function(self)
			self:texcoordvelocity(-0.16,0.16)	
		end;
	};
	Def.Sprite {
		Texture="_sign.png";
		InitCommand=function(self)
			self:Center()
		end;
		OnCommand=function(self)
			self:diffusealpha(0):zoom(0.5):decelerate(0.75):zoom(0.75):diffusealpha(1)
		end;
	};	
	-- Scanline
	Def.Sprite {
		Texture=THEME:GetPathG("ScreenBackground", "scanline");
		InitCommand=function(self)
			self:zoomto(SCREEN_WIDTH,SCREEN_HEIGHT):customtexturerect(0,0,SCREEN_WIDTH*4,SCREEN_HEIGHT*8):Center()
		end;
		OnCommand=function(self)
			self:diffusealpha(0.8)
		end;
	};
};

t[#t+1] = Def.Quad {
		InitCommand=function(self) self:zoomto(SCREEN_WIDTH,SCREEN_HEIGHT):Center():diffuse(color("#50CCEB")) end;
		OnCommand=function(self) self:linear(0.3):diffusealpha(0) end;
	};
t[#t+1] = LoadActor(THEME:GetPathS("GameOver", "sound")) .. {
		OnCommand=function(self) self:queuecommand("Play") end;
		PlayCommand=function(self) self:play() end;
	};	
	
collectgarbage();
return t;